/*******************************************************************************
  ProcessChecker Demo
  Example submitted by David Clegg

  Form used to configure and save any settings for the application.
*******************************************************************************/

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace ProcessChecker
{
	/// <summary>
	/// Summary description for WinForm.
	/// </summary>
	public class SetupForm : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.ListView lvProcesses;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.ListView lvDependants;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.Button btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.Button btnApply;
		private System.Windows.Forms.NumericUpDown nudFrequency;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.CheckBox cbRestartOneProcess;

		private ProcessCheckerSettings settings;
		private System.Windows.Forms.ContextMenu cmProcesses;
		private System.Windows.Forms.MenuItem miAdd;
		private System.Windows.Forms.MenuItem miDelete;
		private System.Windows.Forms.MenuItem miEdit;
		private System.Windows.Forms.Button btnAddProcess;
		private System.Windows.Forms.Button btnEditProcess;
		private System.Windows.Forms.Button btnDeleteProcess;
		private System.Windows.Forms.Button btnAddDependant;
		private System.Windows.Forms.Button btnDeleteDependant;
		private System.Windows.Forms.Button btnEditDependant;
		private System.Windows.Forms.ColumnHeader columnHeader3;

		public SetupForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(SetupForm));
			this.lvProcesses = new System.Windows.Forms.ListView();
			this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader3 = new System.Windows.Forms.ColumnHeader();
			this.cmProcesses = new System.Windows.Forms.ContextMenu();
			this.miAdd = new System.Windows.Forms.MenuItem();
			this.miEdit = new System.Windows.Forms.MenuItem();
			this.miDelete = new System.Windows.Forms.MenuItem();
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.lvDependants = new System.Windows.Forms.ListView();
			this.columnHeader2 = new System.Windows.Forms.ColumnHeader();
			this.btnOK = new System.Windows.Forms.Button();
			this.btnCancel = new System.Windows.Forms.Button();
			this.btnApply = new System.Windows.Forms.Button();
			this.nudFrequency = new System.Windows.Forms.NumericUpDown();
			this.label3 = new System.Windows.Forms.Label();
			this.label4 = new System.Windows.Forms.Label();
			this.cbRestartOneProcess = new System.Windows.Forms.CheckBox();
			this.btnAddProcess = new System.Windows.Forms.Button();
			this.btnEditProcess = new System.Windows.Forms.Button();
			this.btnDeleteProcess = new System.Windows.Forms.Button();
			this.btnAddDependant = new System.Windows.Forms.Button();
			this.btnDeleteDependant = new System.Windows.Forms.Button();
			this.btnEditDependant = new System.Windows.Forms.Button();
			((System.ComponentModel.ISupportInitialize)(this.nudFrequency)).BeginInit();
			this.SuspendLayout();
			// 
			// lvProcesses
			// 
			this.lvProcesses.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
						this.columnHeader1,
						this.columnHeader3});
			this.lvProcesses.ContextMenu = this.cmProcesses;
			this.lvProcesses.FullRowSelect = true;
			this.lvProcesses.HideSelection = false;
			this.lvProcesses.Location = new System.Drawing.Point(16, 24);
			this.lvProcesses.MultiSelect = false;
			this.lvProcesses.Name = "lvProcesses";
			this.lvProcesses.Size = new System.Drawing.Size(344, 264);
			this.lvProcesses.TabIndex = 0;
			this.lvProcesses.View = System.Windows.Forms.View.Details;
			this.lvProcesses.DoubleClick += new System.EventHandler(this.btnEditProcess_Click);
			this.lvProcesses.SelectedIndexChanged += new System.EventHandler(this.lvProcesses_SelectedIndexChanged);
			// 
			// columnHeader1
			// 
			this.columnHeader1.Text = "Process Name";
			this.columnHeader1.Width = 213;
			// 
			// columnHeader3
			// 
			this.columnHeader3.Text = "Check Responding";
			this.columnHeader3.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			this.columnHeader3.Width = 106;
			// 
			// cmProcesses
			// 
			this.cmProcesses.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.miAdd,
						this.miEdit,
						this.miDelete});
			this.cmProcesses.Popup += new System.EventHandler(this.cmProcesses_Popup);
			// 
			// miAdd
			// 
			this.miAdd.Index = 0;
			this.miAdd.Text = "Add";
			this.miAdd.Click += new System.EventHandler(this.miAdd_Click);
			// 
			// miEdit
			// 
			this.miEdit.Index = 1;
			this.miEdit.Text = "Edit";
			this.miEdit.Click += new System.EventHandler(this.miEdit_Click);
			// 
			// miDelete
			// 
			this.miDelete.Index = 2;
			this.miDelete.Text = "Delete";
			this.miDelete.Click += new System.EventHandler(this.miDelete_Click);
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(16, 8);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(100, 16);
			this.label1.TabIndex = 1;
			this.label1.Text = "Processes";
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(376, 8);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(120, 16);
			this.label2.TabIndex = 3;
			this.label2.Text = "Dependent Processes";
			// 
			// lvDependants
			// 
			this.lvDependants.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
						this.columnHeader2});
			this.lvDependants.ContextMenu = this.cmProcesses;
			this.lvDependants.FullRowSelect = true;
			this.lvDependants.HideSelection = false;
			this.lvDependants.Location = new System.Drawing.Point(376, 24);
			this.lvDependants.MultiSelect = false;
			this.lvDependants.Name = "lvDependants";
			this.lvDependants.Size = new System.Drawing.Size(296, 264);
			this.lvDependants.TabIndex = 2;
			this.lvDependants.View = System.Windows.Forms.View.Details;
			this.lvDependants.DoubleClick += new System.EventHandler(this.btnEditDependant_Click);
			this.lvDependants.SelectedIndexChanged += new System.EventHandler(this.lvDependants_SelectedIndexChanged);
			// 
			// columnHeader2
			// 
			this.columnHeader2.Text = "Process Name";
			this.columnHeader2.Width = 260;
			// 
			// btnOK
			// 
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.Location = new System.Drawing.Point(416, 384);
			this.btnOK.Name = "btnOK";
			this.btnOK.TabIndex = 4;
			this.btnOK.Text = "OK";
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(504, 384);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 5;
			this.btnCancel.Text = "Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// btnApply
			// 
			this.btnApply.Enabled = false;
			this.btnApply.Location = new System.Drawing.Point(592, 384);
			this.btnApply.Name = "btnApply";
			this.btnApply.TabIndex = 6;
			this.btnApply.Text = "Apply";
			this.btnApply.Click += new System.EventHandler(this.btnApply_Click);
			// 
			// nudFrequency
			// 
			this.nudFrequency.Location = new System.Drawing.Point(128, 352);
			this.nudFrequency.Minimum = new System.Decimal(new int[] {
						1,
						0,
						0,
						0});
			this.nudFrequency.Name = "nudFrequency";
			this.nudFrequency.Size = new System.Drawing.Size(40, 20);
			this.nudFrequency.TabIndex = 7;
			this.nudFrequency.Value = new System.Decimal(new int[] {
						1,
						0,
						0,
						0});
			this.nudFrequency.Click += new System.EventHandler(this.nudFrequency_Click);
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(16, 352);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(112, 16);
			this.label3.TabIndex = 8;
			this.label3.Text = "Checking Frequency";
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(176, 352);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(112, 16);
			this.label4.TabIndex = 9;
			this.label4.Text = "seconds";
			// 
			// cbRestartOneProcess
			// 
			this.cbRestartOneProcess.Location = new System.Drawing.Point(16, 376);
			this.cbRestartOneProcess.Name = "cbRestartOneProcess";
			this.cbRestartOneProcess.Size = new System.Drawing.Size(232, 24);
			this.cbRestartOneProcess.TabIndex = 10;
			this.cbRestartOneProcess.Text = "Restart Only One Process Per Check";
			this.cbRestartOneProcess.Click += new System.EventHandler(this.cbRestartOneProcess_Click);
			// 
			// btnAddProcess
			// 
			this.btnAddProcess.Location = new System.Drawing.Point(16, 296);
			this.btnAddProcess.Name = "btnAddProcess";
			this.btnAddProcess.TabIndex = 14;
			this.btnAddProcess.Text = "Add";
			this.btnAddProcess.Click += new System.EventHandler(this.btnAddProcess_Click);
			// 
			// btnEditProcess
			// 
			this.btnEditProcess.Location = new System.Drawing.Point(104, 296);
			this.btnEditProcess.Name = "btnEditProcess";
			this.btnEditProcess.TabIndex = 15;
			this.btnEditProcess.Text = "Edit";
			this.btnEditProcess.Click += new System.EventHandler(this.btnEditProcess_Click);
			// 
			// btnDeleteProcess
			// 
			this.btnDeleteProcess.Location = new System.Drawing.Point(192, 296);
			this.btnDeleteProcess.Name = "btnDeleteProcess";
			this.btnDeleteProcess.TabIndex = 16;
			this.btnDeleteProcess.Text = "Delete";
			this.btnDeleteProcess.Click += new System.EventHandler(this.btnDeleteProcess_Click);
			// 
			// btnAddDependant
			// 
			this.btnAddDependant.Enabled = false;
			this.btnAddDependant.Location = new System.Drawing.Point(376, 296);
			this.btnAddDependant.Name = "btnAddDependant";
			this.btnAddDependant.TabIndex = 17;
			this.btnAddDependant.Text = "Add";
			this.btnAddDependant.Click += new System.EventHandler(this.btnAddDependant_Click);
			// 
			// btnDeleteDependant
			// 
			this.btnDeleteDependant.Enabled = false;
			this.btnDeleteDependant.Location = new System.Drawing.Point(552, 296);
			this.btnDeleteDependant.Name = "btnDeleteDependant";
			this.btnDeleteDependant.TabIndex = 18;
			this.btnDeleteDependant.Text = "Delete";
			this.btnDeleteDependant.Click += new System.EventHandler(this.btnDeleteDependant_Click);
			// 
			// btnEditDependant
			// 
			this.btnEditDependant.Enabled = false;
			this.btnEditDependant.Location = new System.Drawing.Point(464, 296);
			this.btnEditDependant.Name = "btnEditDependant";
			this.btnEditDependant.TabIndex = 19;
			this.btnEditDependant.Text = "Edit";
			this.btnEditDependant.Click += new System.EventHandler(this.btnEditDependant_Click);
			// 
			// SetupForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(690, 420);
			this.Controls.Add(this.btnEditDependant);
			this.Controls.Add(this.btnDeleteDependant);
			this.Controls.Add(this.btnAddDependant);
			this.Controls.Add(this.btnDeleteProcess);
			this.Controls.Add(this.btnEditProcess);
			this.Controls.Add(this.btnAddProcess);
			this.Controls.Add(this.cbRestartOneProcess);
			this.Controls.Add(this.label4);
			this.Controls.Add(this.label3);
			this.Controls.Add(this.nudFrequency);
			this.Controls.Add(this.btnApply);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.lvDependants);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.lvProcesses);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "SetupForm";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "Process Checker Setup";
			this.Load += new System.EventHandler(this.SetupForm_Load);
			((System.ComponentModel.ISupportInitialize)(this.nudFrequency)).EndInit();
			this.ResumeLayout(false);
		}
		#endregion

		public static DialogResult ShowSetupForm(ProcessCheckerSettings settings) {
			SetupForm sf = new SetupForm();
			sf.settings = settings;
			return sf.ShowDialog();
		}

		private void SetupForm_Load(object sender, System.EventArgs e) {
			PopulateControls();
		}

		/// <summary>
		/// Populate the GUI controls based on the details contained in the
		/// ProcessCheckerSettings reference.
		/// </summary>
		private void PopulateControls() {
			nudFrequency.Value = settings.CheckFrequency;
			cbRestartOneProcess.Checked = settings.RestartOneProcess;

			//Populate the Process and Dependant Process list views
			foreach (WatchedProcess process in settings.WatchedProcesses) {
				AddProcess(process, lvProcesses);
			}
		}

		/// <summary>
		/// Add details of a watched process to the ListView.
		/// </summary>
		private void AddProcess(ProcessDetails process, ListView listView) {
			ListViewItem lvi = new ListViewItem(process.ProcessPath);
			lvi.Tag = process;
			listView.Items.Add(lvi);
			if (process is WatchedProcess)
				lvi.SubItems.Add(((WatchedProcess)process).CheckResponding.ToString());
		}

		/// <summary>
		/// Populate the Dependant Process ListView for the currently selected
		/// item in the Watched Process ListView.
		/// </summary>
		private void lvProcesses_SelectedIndexChanged(object sender, System.EventArgs e) {
			//As MultiSelect is false, there will only ever be at most one item in
			//the SelectedItems collection
			int lIndex = SelectedIndex(lvProcesses);
			if (lIndex != -1)
				AddDependants((WatchedProcess)settings.WatchedProcesses[lIndex]);
			EnableProcessButtons();
			EnableDependantButtons();
		}

		/// <summary>
		/// Ensure we can only Edit or Delete if a process is selected.
		/// </summary>
		private void EnableProcessButtons() {
			//Ensure we can only Edit or Delete if a process is selected
			btnEditProcess.Enabled = (SelectedIndex(lvProcesses) != -1);
			btnDeleteProcess.Enabled = btnEditProcess.Enabled;
		}

		/// <summary>
		/// Populate the Dependants Process ListView based on the passed in
		/// WatchedProcess reference.
		/// </summary>
		private void AddDependants(WatchedProcess process) {
			lvDependants.Items.Clear();
			foreach(DependantProcess dp in process.DependantProcesses) {
				AddProcess(dp, lvDependants);
			}
		}

		/// <summary>
		/// Need to ensure that we are only enabling Edit and Delete menu items
		/// if a ListViewItem is selected, and that we only enable the Add
		/// menu item for the dependant processes ListView if a watched process
		/// has been selected.
		/// </summary>
		private void cmProcesses_Popup(object sender, System.EventArgs e) {
			//Get a reference to the ListView the context menu is associated with
			ListView lv = (ListView)((ContextMenu)sender).SourceControl;

			//Only allow editing or deleting if a ListViewItem is selected
			miEdit.Enabled = (lv.SelectedItems.Count != 0);
			miDelete.Enabled = miEdit.Enabled;

			//Only allow adding of dependant processes if a watched process is
			//selected
			if (lv == lvDependants)
				miAdd.Enabled = (lvProcesses.SelectedItems.Count != 0);
		}

		/// <summary>
		/// Returns the index for the last of the currently selected items in
		/// a ListView.
		/// </summary>
		private int SelectedIndex(ListView lv) {
			int retVal = -1;
			foreach (int i in lv.SelectedIndices)
				retVal = i;
			return retVal;
		}

		/// <summary>
		/// Returns the ListViewItem reference for the last of the currently
		/// selected items in a ListView.
		/// </summary>
		private ListViewItem SelectedItem(ListView lv) {
			ListViewItem retVal = null;
			foreach (ListViewItem lvi in lv.SelectedItems)
				retVal = lvi;
			return retVal;
		}

		private void miDelete_Click(object sender, System.EventArgs e) {
			//Get a reference to the ListView the MenuItem is assocated
			//with. The sender parameter is a reference to the MenuItem object,
			//who's parent will be a ContextMenu. From the ContextMenu reference
			//we can determine the SourceControl (in this case, which ListView
			//initiated the request)
			ListView lv = (ListView)((ContextMenu)((MenuItem)sender).Parent).SourceControl;
			DoDelete(lv);
		}

		/// <summary>
		/// Delete the selected ListViewItem from the ListView (and associated
		/// ProcessList reference).
		/// </summary>
		private void DoDelete(ListView lv) {
			//Index to selected ListViewItem
			ListViewItem selectedItem = SelectedItem(lv);

			if (lv == lvProcesses) {
				//Delete watched process
				if (selectedItem != null) {
					//Delete from ProcessCheckerSettings object
					settings.WatchedProcesses.Remove((WatchedProcess)selectedItem.Tag);
					//Remove from ListView
					lv.Items.RemoveAt(selectedItem.Index);
					//Clear the dependant processes ListView
					lvDependants.Items.Clear();
				}
			}
			else {
				//Delete dependant process
				if (selectedItem != null) {
					//Reference
					ListViewItem watchedItem = SelectedItem(lvProcesses);
					if (watchedItem != null) {
						((WatchedProcess)watchedItem.Tag).DependantProcesses.Remove((DependantProcess)selectedItem.Tag);
						lv.Items.RemoveAt(selectedItem.Index);
					}
				}
			}
			btnApply.Enabled = true;
		}

		private void miAdd_Click(object sender, System.EventArgs e) {
			//Get a reference to the ListView the MenuItem is assocated
			//with. The sender parameter is a reference to the MenuItem object,
			//who's parent will be a ContextMenu. From the ContextMenu reference
			//we can determine the SourceControl (in this case, which ListView
			//initiated the request)
			ListView lv = (ListView)((ContextMenu)((MenuItem)sender).Parent).SourceControl;
			DoAdd(lv);
		}

		/// <summary>
		/// Add a process to the selected ListView (and associated ProcessList
		/// reference).
		/// </summary>
		private void DoAdd(ListView lv) {
			ProcessList pl;
			ProcessDetails pd;

			//selected ListViewItem
			ListViewItem selectedItem = SelectedItem(lv);

			if (lv == lvProcesses) {
				//Adding a new watched process
				pl = settings.WatchedProcesses;
				pd = new WatchedProcess("");
			}
			else {
				//Adding a new dependant process
				pl = ((WatchedProcess)settings.WatchedProcesses[SelectedIndex(lvProcesses)]).DependantProcesses;
				WatchedProcess wp = (WatchedProcess)SelectedItem(lvProcesses).Tag;
				pd = new DependantProcess("", wp);
			}

			if (ProcessDetailsForm.ShowProcessDetails(pd) == DialogResult.OK) {
				pl.Add(pd);
				AddProcess(pd, lv);
			}
			btnApply.Enabled = true;
		}

		private void miEdit_Click(object sender, System.EventArgs e) {
			//Get a reference to the ListView the MenuItem is assocated
			//with. The sender parameter is a reference to the MenuItem object,
			//who's parent will be a ContextMenu. From the ContextMenu reference
			//we can determine the SourceControl (in this case, which ListView
			//initiated the request)
			ListView lv = (ListView)((ContextMenu)((MenuItem)sender).Parent).SourceControl;
			DoEdit(lv);
		}

		/// <summary>
		/// Edit the details of the selected ListViewItem (and associated
		/// ProcessDetail reference).
		/// </summary>
		private void DoEdit(ListView lv) {
			//selected ListViewItem
			ListViewItem selectedItem = SelectedItem(lv);

			//Reference to ProcessDetails object
			ProcessDetails pd = (ProcessDetails)selectedItem.Tag;

			if (ProcessDetailsForm.ShowProcessDetails(pd) == DialogResult.OK) {
				//Update the ListViewItem to display the updated process details
				selectedItem.Text = pd.ProcessPath;
				if (pd is WatchedProcess)
					selectedItem.SubItems[1].Text = ((WatchedProcess)pd).CheckResponding.ToString();
			}
			btnApply.Enabled = true;
		}

		private void btnAddProcess_Click(object sender, System.EventArgs e) {
			DoAdd(lvProcesses);
		}

		private void btnEditProcess_Click(object sender, System.EventArgs e) {
			DoEdit(lvProcesses);
		}

		private void btnDeleteProcess_Click(object sender, System.EventArgs e) {
			DoDelete(lvProcesses);
		}

		private void lvDependants_SelectedIndexChanged(object sender, System.EventArgs e) {
			EnableDependantButtons();
		}

		/// <summary>
		/// Ensure we can only Edit or Delete if a dependant process is selected,
		/// and can only Add if a watched process is selected.
		/// </summary>
		private void EnableDependantButtons() {
			//Ensure we can only Add if a watched process is selected
			btnAddDependant.Enabled = (SelectedIndex(lvProcesses) != -1);

			//Ensure we can only Edit or Delete if a dependant process is selected
			btnEditDependant.Enabled = (SelectedIndex(lvDependants) != -1);
			btnDeleteDependant.Enabled = btnEditDependant.Enabled;
		}

		private void btnAddDependant_Click(object sender, System.EventArgs e) {
			DoAdd(lvDependants);
		}

		private void btnEditDependant_Click(object sender, System.EventArgs e) {
			DoEdit(lvDependants);
		}

		private void btnDeleteDependant_Click(object sender, System.EventArgs e) {
			DoDelete(lvDependants);
		}

		private void btnOK_Click(object sender, System.EventArgs e) {
			SaveSettings();
		}

		/// <summary>
		/// Save the settings to disk (in .\ProcessChecker.dat)
		/// </summary>
		private void SaveSettings() {
			//Update the ProcessCheckerSettings instance. The WatchedProcesses
			//list would have already been updated, so we only need to
			//update any additional properties.
			settings.CheckFrequency = (int)nudFrequency.Value;
			settings.RestartOneProcess = cbRestartOneProcess.Checked;

			//Save to disk
			try {
				settings.Save();
			}
			catch (Exception e) {
				MessageBox.Show(string.Format("There was an error saving settings to disk: {0}",
								e.Message));
			}
		}

		private void nudFrequency_Click(object sender, System.EventArgs e) {
			btnApply.Enabled = true;
		}

		private void cbRestartOneProcess_Click(object sender, System.EventArgs e) {
			btnApply.Enabled = true;
		}

		private void btnApply_Click(object sender, System.EventArgs e) {
			SaveSettings();
			btnApply.Enabled = false;
		}

		private void btnCancel_Click(object sender, System.EventArgs e) {
			settings = ProcessCheckerSettings.Load();
		}
	}
}
